"use client"
export const unstable_revalidate = 1
import './game.css'
import Image from 'next/image'
import { useEffect, useState } from 'react';
import Layout from './layout'
import { SlRefresh } from 'react-icons/sl';
import { FaChevronDown, FaChevronUp } from 'react-icons/fa';
import axios from 'axios'

export default function Home() {

  const [allletters, setallletters] = useState('')
  const [mainletter, setmainletter] = useState('')
  const [totalwords, settotalwords] = useState('')
  const [todaysdate, settodaysdate] = useState('')
  const [word, setword] = useState('')
  const [todaysresult, settodaysresult] = useState('')
  const [todaysresultarr, settodaysresultarr] = useState('')
  const [error, seterror] = useState('')
  const [loading, setloading] = useState(true)
  const [showwords, setshowwords] = useState(false)
  const [play, setplay] = useState(false)
  const letters = (allletters.replace(mainletter, '')).split("")

    const fetchresult = () => {
        const date = new Date();
        let currentDay= String(date.getDate()).padStart(2, '0');
        let currentMonth = String(date.getMonth()+1).padStart(2,"0");
        let currentYear = date.getFullYear();
        let currentDate = `${currentYear}-${currentMonth}-${currentDay}`;
        const currentMonthIndex = date.getMonth();
        const currentMonthName = ['January','February','March','April','May','June','July','August','September','October','November','December'][currentMonthIndex];
        const storedRecordData = getDataWithExpiration(currentDate);

        settodaysdate(currentMonthName+" "+currentDay+", "+currentYear)
        settodaysresult(storedRecordData)
        if(storedRecordData != null){
        settodaysresultarr(storedRecordData.split(","))
        } 
    }

    const getpuzzle = () => {
    axios
        .get('http://localhost:3000/api/api')
        .then(response => {
        let result = JSON.parse(response.data)[0];
        setallletters(result.letters)
        setmainletter(result.mainletter)
        settotalwords(result.totalwords)
        setloading(false)
        })
        .catch(error => {
        setloading(false)
        })
    }

    useEffect(() => {
        getpuzzle()
        fetchresult()
    }, []);
  

    const removeletter = () => {
        if (word != "") {
            setword(word.slice(0, -1));
        }
    }

    const updateDataWithExpiration = (key, value, expirationHours) => {
        const existingValue = localStorage.getItem(key);
      
        if (existingValue) {
            const updatedValue = `${existingValue}, ${value}`;
            localStorage.setItem(key, updatedValue);
          } else {
            localStorage.setItem(key, value);
        }
      
        // Set the expiration time
        const expirationMs = expirationHours * 60 * 60 * 1000;
        const expirationTime = Date.now() + expirationMs;
        localStorage.setItem(`${key}_expiration`, expirationTime);
    };
      
    const getDataWithExpiration = (key) => {
    const expirationTime = localStorage.getItem(`${key}_expiration`);
    if (expirationTime && Date.now() > expirationTime) {
        // If the expiration time has passed, remove the data
        localStorage.removeItem(key);
        localStorage.removeItem(`${key}_expiration`);
        return null;
    }
    
    return localStorage.getItem(key);
    };

    const verifyword = () => {
        if (word != "") {
            if (word.length > 3) {
                if (word.indexOf(mainletter) > -1) {
                    const wordData = {
                        value: word
                    }
                    axios
                        .post('http://localhost:3000/api/api', wordData)
                        .then(response => {
                        let result = JSON.parse(response.data)[0];
                        if(result.found == 1){
                            setword('')
                            const date = result.date
                            const exists = todaysresultarr.includes(word);
                            if(exists){
                            seterror('Already found')
                            }
                            else{
                            seterror('Word found +1')
                            updateDataWithExpiration(date, word, 24);
                            fetchresult();
                            }
                        }
                        else if(result.found == 0){
                            seterror('Not in word list')
                        }
                        setloading(false)
                        })
                        .catch(error => {
                        seterror(error)
                        setloading(false)
                        })

                }else{
                    seterror('Missing center letter')
                    setTimeout(function() {
                        seterror('')
                    }, 2000);
                }
            }
            else{
                seterror('Too short')
                setTimeout(function() {
                    seterror('')
                }, 2000);
            }
        }
    }

    // localStorage.clear();

  return (
    <Layout>
    {
    play == false ? 
    <main className='min-h-screen justify-center flex bg-main'>
        <div className='mx-auto max-w-screen-sm text-center'>
            <div className='text-white text-2xl font-semibold' style={{lineHeight: 1.75, letterSpacing:2}}>How many words can you make with<br></br>7 letters?</div>
            <div className='text-neutral-300 my-5'>{todaysdate}</div>
            <button onClick={() => setplay(true)} className='play-btn'>{((todaysresultarr).length > 0) ? 'Keep Playing' : 'Start Now'}</button>
            {((todaysresultarr).length) > 0 ? <div className='mt-5 text text-neutral-400'>You have found <b>{((todaysresultarr).length == totalwords) ? 'all' : '' } {((todaysresultarr).length) > 1 ? ((todaysresultarr).length)+" words" : ((todaysresultarr).length)+" word" }</b></div> : '' }
        </div>
    </main>
    : 
    <main> 
    {
    (loading == true) ? 
    <div className='w-full flex-1 py-20 justify-center text-center mx-auto max-w-screen-sm my-10'>Loading...</div>
    :
    <div className="w-full mx-auto max-w-screen-sm my-10 mb-20">
        { ((todaysresultarr).length == totalwords) ? <div className='success-box'>Great Job! You have an amazing vocabulary</div> : <><div className="word-box">{word}</div><div className={`error-box ${error == "" ? '' : 'show'}`} >
            <span>{error}</span>
        </div></>}
        <div className="result-box">
            <div className='flex flex-row justify-between'>
                <div className='title'>You have found {((todaysresultarr).length == totalwords) ? 'all' : '' } {((todaysresultarr).length) > 1 ? ((todaysresultarr).length)+" words" : ((todaysresultarr).length)+" word" }</div>
                <div><span className='cursor-pointer' onClick={() => setshowwords(!showwords)}>{(showwords == false) ? <FaChevronDown /> : <FaChevronUp /> }</span></div>
            </div>
            { ((todaysresultarr).length > 0) ? <div><progress className='progress' value={(((todaysresultarr).length) / totalwords * 100)} max="100"> 32% </progress></div> : ''}
            <div className={`found-words ${(showwords == false) ? 'hidden' : 'show'} `}>{todaysresult}<div className='text-neutral-400 font-light text-sm mt-10'>{totalwords} possible words today</div></div>
        </div>
        <div className="letter-box">
            <div className="hex">
                <svg className="hex-cell center" viewBox="0 0 120 103.92304845413263" onClick={() => { setword((prevLetters) => prevLetters + mainletter) }}>
                    <polygon className="cell-fill" points="0,51.96152422706631 30,0 90,0 120,51.96152422706631 90,103.92304845413263 30,103.92304845413263" stroke="white" strokeWidth="7.5"></polygon><text className="cell-letter" x="50%" y="50%" dy="0.35em">{mainletter}</text>
                </svg>
                { letters.map((hex, index) => (
                    <svg className="hex-cell outer" viewBox="0 0 120 103.92304845413263" key={index} onClick={() => { setword((prevLetters) => prevLetters + hex) }}>
                        <polygon className="cell-fill" points="0,51.96152422706631 30,0 90,0 120,51.96152422706631 90,103.92304845413263 30,103.92304845413263" stroke="white" strokeWidth="7.5"></polygon><text className="cell-letter" x="50%" y="50%" dy="0.35em">{hex}</text>
                    </svg>
                ))
                }
            </div>
            
        </div>
        { ((todaysresultarr).length == totalwords) ? '' : 
        <div className={`action-btns ${word == "" ? 'opacity-60' : ''}`}>
            <button className={`btn-delete`} onClick={() => removeletter()}>Delete</button>
            <SlRefresh class='btn-reset'/>
            <button className={`btn-submit`} onClick={() => verifyword()}>Submit</button>
        </div>
        }
    </div>
    }
    </main>
    } 
       <footer className='space-y-5'>
       <div>Created by <span>Usman Malik</span> with ❤️</div>
       <div><a href='https://developmint.xyz/'>Developmint.xyz</a></div>
     </footer>
    </Layout>
  )
}
